function ret = pNormExample_multi_cuda_wrapper(rir, wd, wu, h, numIter, mue, pd, pu)


%%gather data
%
[Lc, speakers, microphones] = size(rir);
[Lh,~] = size(h);

Lg = Lc+Lh-1;
Ln = 2^(nextpow2(Lg));           


%% pad data for the fft length
%
rir_long = zeros(Ln,speakers, microphones);
rir_long(1:Lc,:,:) = rir;
rir_long = rir_long(:);

wd_long = zeros(Ln, microphones);
wd_long(1:Lg, :) = reshape(wd,Lg,microphones);
wd_long = wd_long(:);
wu_long = zeros(Ln, microphones);
wu_long(1:Lg, :) = reshape(wu,Lg,microphones);
wu_long = wu_long(:);

h_long = zeros(Ln, speakers);
h_long(1:Lh, :) = reshape(h,Lh,speakers);
h_long = h_long(:);

%% function call
%

ret = filt_shortening(rir_long, wd_long, wu_long, h_long, Lc, Lh, Lg, Ln, numIter, mue, pd, pu, speakers, microphones);
return 