clear all;
    

load HABETS_RIRs.mat
%% inits
numIter = 10000;
mue=1e-9;

J=zeros(numIter,1);
JJ_old = 10^10;

Lh = 3000;
Lg = Lc+Lh-1;
Ln = 2^(nextpow2(Lg));           

speakers    = max(spkIndices);
microphones = max(micIndices);

rir = reshape(RIRs, Lc, speakers, microphones);


c= squeeze(sum(rir(:,:,:),2));

wd = zeros(Lg,microphones);
wu = zeros(Lg,microphones);

for ii = 1:microphones
    [wd(:,ii), wu(:,ii)]  = getWindowForRIRs(rir(:,:,ii), fs, Lh);
end

wd = wd(:);
wu = wu(:);


%% parameters for the pNorm
pd=10;
pu=20;

%% initial equalizer
h = zeros(Lh, speakers);
h(1,:)=0.001;

C  = fft(rir,Ln,1);
Ck = conj(C);

J=zeros(numIter,1);

tic
ret = pNormExample_multi_cuda_wrapper(rir, wd, wu, h, numIter, mue, pd, pu);
toc

ret = real(ret(1:Ln*speakers));

ret = reshape(ret,[],speakers);
ret = ret(1:Lh,:);


    h_fft = fft(ret,Ln);
    for ii = 1:microphones
        gk(:,ii) = real(ifft(sum(C(:,:,ii).*h_fft,2)));
    end
    g0=gk(1:Lg,:);




%%
%return
wur = wu(1:4999);


figure(1);
subplot(3,1,1);
plot(20*log10(abs(c./max(max(abs(c)))))); ylim([-80 5]);
axis([0, Lg, -100 5]); grid on
title('RIR');
hold on;
max_g = max(abs(g0(:,1)));
plot(20*log10(1./wur),'k','LineWidth',2);
hold off;


subplot(3,1,2);
plot(20*log10(abs(g0./max(max(abs(g0)))))); ylim([-80 5]);
axis([0, Lg, -100 5]); grid on
title('reshaped RIR');
hold on;
max_g = max(abs(g0(:,1)));
plot(20*log10(1./wur),'k','LineWidth',2);
hold off;

subplot(3,1,3);
plot(20*log10(abs(sum(g0,2)./max(sum((g0),2)))));
axis([0, Lg, -100 5]); grid on
title('average reshaped RIR');
hold on;
max_g = max(abs(g0(:,1)));
plot(20*log10(1./wur),'k','LineWidth',2);
hold off;



%Remove this for matlab comparison
return


tic
for iter=1:numIter
    %%calculate the resulting RIR to the microphones
   h_fft = fft(h,Ln);
   for ii = 1:microphones
       gk(:,ii) = real(ifft(sum(C(:,:,ii).*h_fft,2)));
   end
    g0=gk(1:Lg,:);                                         % truncate to length L to get current global impulse response

    gu=g0(:).*wu;
    Bgu = abs(gu).^(pu-1);
    bu = sign(gu).*wu.*Bgu;

    SAgu = 1 / (Bgu' * abs(gu));
    bu = reshape(bu,Lg,microphones);
    
    gd=g0(:).*wd;                                          % gd is the desired part of the global RIR
    Bgd=abs(gd).^(pd-1);
    bd = sign(gd).*wd.*Bgd;
    SAgd = 1 / (Bgd'*abs(gd));
    bd = reshape(bd,Lg,microphones);
    
    b_fft = fft(SAgu*bu - SAgd*bd,Ln);

    for ii = 1:speakers
        F1(:,ii) = real(ifft(sum(squeeze(Ck(:,ii,:)).*b_fft,2)));
    end
    
    df1=F1(1:Lh,:);

    
    h=h-mue*df1;

%    JJ = norm(gu, pu)/norm(gd, pd);
    JJ = (1/SAgu)^(1/pu) /((1/SAgd)^(1/pd));

    if (JJ>JJ_old)
        mue = mue/2;
        fprintf('-----> Stepsize has been halved in iteration: %i\n',iter);
    end
    JJ_old=JJ;

    
    J(iter)= JJ;
%    [iter J(iter)]
    
    fprintf('Iteration %i: J %f \n ', iter, JJ);
    
end
tges = toc;
fprintf('Time used for gradient descent (matlab): %1.2fs\n',tges);
fprintf('Time used for one step of the gradient:  %1.2fms\n',1000*tges/iter);


%% retrieve the results.
%c= squeeze(sum(rir(:,:,:),2));

figure(2);
subplot(3,1,1);
plot(20*log10(abs(c./max(max(abs(c)))))); ylim([-80 5]);
title('RIR');
subplot(3,1,2);
plot(20*log10(abs(g0./max(max(abs(g0)))))); ylim([-80 5]);
title('reshaped RIR');
subplot(3,1,3);
plot(J);
title('Objective value');


figure(2);
subplot(2,1,1)
plot([ret(:) h(:)]);
subplot(2,1,2)
plot([ret(:)-h(:)]);

%d = c - 1000*g0(1:Lc,:);
%plot(20*log10(abs(d./max(max(abs(g0)))))); ylim([-80 5]);
%title('diff');

return





