%clear all;

%% load our data:
% -RIR : c
% -weighting window for the wanted part : wd
% -weighting window for the unwanted part: wu (temporal masking limit ==
%           1./wu on a logarithmic scale)
% -sampling rate of the RIR : fs
% -length of the equalizer : Lh
% 
% load PNORM_DATA;

%load PNORM_DATA_LC800;          %Lc=800     Lh=800

%load PNORM_DATA_LC2000;        %Lc=2000    Lh=2000
%load PNORM_DATA_LC8192;        %Lc=8192    Lh=4096
load PNORM_DATA_LC16384;       %Lc=16384   Lh=8192

%% initial equalizer
h = zeros(Lh, 1);
h(1)=0.001;

%% parameters for the pNorm
pd=10;
pu=20;

%% perform numIter iterations with a stepsize of 1e-11.
% we could have bigger stepsize but then we would need some additional
% steps to assure a decrease of the objective function in order to keep
% everythin stable.
numIter = 5000;
numIter = 500;
mue=1e-11;

Lc=length(c);                    % length of RIR
Lg=Lc+Lh-1;                      % length of the global impulse response

%% initialization
Ln = 2^(nextpow2(Lg));                                     % apply FFT of length Ln ...
Ck=conj(fft(c,Ln));
Ck1=fft(c,Ln);

%% save the values of the objective function ...
J = zeros(numIter, 1);

disp('hello');

%h= rand(size(h));

tic
y = filt_shortening(c, wd, wu, h, Ln, numIter);
toc
%y= real(y(1:1599));
%y= real(y(1:800));
y= real(y(1:Lh));
%y = real(y);
%y(1:10)


tic
%% start the gradient descent optimization procedure
for iter=1:numIter
%% calculate the objective value and the gradient for the given equalizer
    gk=real(ifft(Ck1.*fft(h,Ln)));                      % calculate the convolution result c*h with a support size of Ln
    g0=gk(1:Lg);                                         % truncate to length L to get current global impulse response

    
    gu=g0.*wu;                                          % gu is the unwanted part of the global RIR
    Bgu = abs(gu).^(pu-1);
    bu =  sign(gu).*wu.*Bgu;
    SAgu = 1 / (Bgu' * abs(gu));
    
    
    gd=g0.*wd;                                          % gd is the desired part of the global RIR
    Bgd=abs(gd).^(pd-1);
    bd = sign(gd).*wd.*Bgd;
    SAgd = 1 / (Bgd'*abs(gd));
    
    
%    F1=real(ifft(Ck.*fft(bu,Ln)));
%    df1=SAgu*F1(1:Lh);                                       % this is the gradient derived from the unwanted part
    
%    F2=real(ifft(Ck.*fft(bd,Ln)));
%    df2=SAgd*F2(1:Lh);                                       % this is the gradient derived from the desired part

    %Fges=real(ifft(Ck.*fft(SAgu*bu,Ln)-Ck.*fft(SAgd*bd,Ln)));
    Fges=real(ifft(Ck.*fft(SAgu*bu-SAgd*bd,Ln)));
    %df1=SAgu*F1(1:Lh);                                       % this is the gradient derived from the unwanted part
    

%% return the gradient and the objective value for the given equalizer
    %q=norm(gu, pu)/norm(gd, pd);                        % compute the value of the objective function
%    dh=;                                         % compute the gradient at h
    
    if (iter ==1)
        SAgu
        SAgd
    end
%% apply gradient descent with stepsize mue
%    h=h-mue*(df1-df2);
    h=h-mue*Fges(1:Lh);
    
%% print out the current objective value    
    %fprintf('[%i] : %.2f\n', iter, q);
    J(iter)=q;
end
toc
figure(1)
plot([y-h]);

%return

%% compute the reshaped RIR
g=conv(c,h);

figure(2);
subplot(3,1,1);
plot(20*log10(abs(c./max(abs(c))))); ylim([-80 5]);
title('RIR');
subplot(3,1,2);
plot(20*log10(abs(g./max(abs(g))))); ylim([-80 5]);
title('reshaped RIR');
subplot(3,1,3);
plot(J);
title('Objective value');
