#include "../include/icaData.h"



icaData::icaData(): data_points(0), f_bins(1), iterations(200) {};
icaData::icaData(int d_points, int fb): data_points(d_points), f_bins(fb), data_ges(d_points*fb), iterations(200), step_size(0.02f) {
    int DATA_ges = data_points * f_bins;
    in  = new cu2dVect[data_ges];
    out = new cu2dVect[data_ges];
    w = new cu2dMatrix[f_bins];

    cudaMalloc( (void**)&dev_in,  DATA_ges   * sizeof(cu2dVect));
    cudaMalloc( (void**)&dev_out, DATA_ges   * sizeof(cu2dVect));
    cudaMalloc( (void**)&dev_w,   f_bins * sizeof(cu2dMatrix));
};

icaData::icaData(int d_points, int fb, int it): data_points(d_points), f_bins(fb), data_ges(d_points*fb), iterations(it), step_size(0.02f) {
    int DATA_ges = data_points * f_bins;
    in  = new cu2dVect[data_ges];
    out = new cu2dVect[data_ges];
    w = new cu2dMatrix[f_bins];

    cudaMalloc( (void**)&dev_in,  DATA_ges   * sizeof(cu2dVect));
    cudaMalloc( (void**)&dev_out, DATA_ges   * sizeof(cu2dVect));
    cudaMalloc( (void**)&dev_w,   f_bins * sizeof(cu2dMatrix));
};


icaData::~icaData(){
    delete in;
    delete out;
    delete w;
    cudaFree(dev_in);
    cudaFree(dev_out);
    cudaFree(dev_w);
};

void icaData::copyToDevice(){
    cudaMemcpy(dev_in, in, data_ges   * sizeof(cu2dVect), cudaMemcpyHostToDevice);
    cudaMemcpy(dev_w, w,   f_bins * sizeof(cu2dMatrix), cudaMemcpyHostToDevice);
};
void icaData::copyToHost(){
    //cudaMemcpy(out, dev_out, data_ges   * sizeof(cu2dVect), cudaMemcpyDeviceToHost);
    cudaMemcpy(w,  dev_w,    f_bins * sizeof(cu2dMatrix), cudaMemcpyDeviceToHost);
};

















icaData_3d::icaData_3d(): data_points(0), f_bins(1), iterations(200) {};
icaData_3d::icaData_3d(int d_points, int fb): data_points(d_points), f_bins(fb), data_ges(d_points*fb), iterations(200), step_size(0.02f) {
    int DATA_ges = data_points * f_bins;
    inv_mlen = (1.0f/(float)data_points);
    in  = new cu3dVect[data_ges];
    out = new cu3dVect[data_ges];
    w = new cu3dMatrix[f_bins];

    cudaMalloc( (void**)&dev_in,  DATA_ges   * sizeof(cu3dVect));
    cudaMalloc( (void**)&dev_out, DATA_ges   * sizeof(cu3dVect));
    cudaMalloc( (void**)&dev_w,   f_bins * sizeof(cu3dMatrix));
};

icaData_3d::icaData_3d(int d_points, int fb, int it): data_points(d_points), f_bins(fb), data_ges(d_points*fb), iterations(it), step_size(0.02f) {
    int DATA_ges = data_points * f_bins;
    inv_mlen = (1.0f/(float)data_points);
    in  = new cu3dVect[data_ges];
    out = new cu3dVect[data_ges];
    w = new cu3dMatrix[f_bins];

    cudaMalloc( (void**)&dev_in,  DATA_ges   * sizeof(cu3dVect));
    cudaMalloc( (void**)&dev_out, DATA_ges   * sizeof(cu3dVect));
    cudaMalloc( (void**)&dev_w,   f_bins * sizeof(cu3dMatrix));
};


icaData_3d::~icaData_3d(){
    delete in;
    delete out;
    delete w;
    cudaFree(dev_in);
    cudaFree(dev_out);
    cudaFree(dev_w);
};

void icaData_3d::copyToDevice(){
    cudaMemcpy(dev_in, in, data_ges   * sizeof(cu3dVect), cudaMemcpyHostToDevice);
    cudaMemcpy(dev_w, w,   f_bins * sizeof(cu3dMatrix), cudaMemcpyHostToDevice);
};
void icaData_3d::copyToHost(){
    //cudaMemcpy(out, dev_out, data_ges   * sizeof(cu3dVect), cudaMemcpyDeviceToHost);
    cudaMemcpy(w,  dev_w,    f_bins * sizeof(cu3dMatrix), cudaMemcpyDeviceToHost);
};






