%%
% calculates the windows wd and wu for one microphone
%
% RIRs contains a bunch of RIRs. we calculate the weighting windows
% according to tiemins IWAENC2010 paper by exploiting the temporal masking
% curce. the direct sound component is taken as the minimum time of the
% direct sound over all RIRs...
%
function [ wd, wu ] = getWindowForRIRs( RIRs, fs, Lh )
    Lc = size(RIRs, 1);
    Lg = Lc+Lh-1;
    
    [~, N0] = max(abs(RIRs));
    N1 = min(N0);
    
    % compromise temporal masking limit window
%    [~, N1]=max(abs(c));        % index of the first impulse of the RIR (direct sound)
    N2=round(0.004*fs);             % N2 is the number of samples for 4 ms
    n2=(N1+N2:Lg)';
    % compute the temporal masking limit
    w0=10.^(-3.*log10((N1+N2)./n2)/log10((round(0.2*fs)+N1)/(N1+N2)))*10^(0.5);
    % set the windows accoding to the parts calculated just above ...
    wu=[zeros(N1+N2-1,1); w0(:)];                               % unwanted part
    wd = [zeros(N1-1, 1); ones(N2, 1); zeros(length(w0), 1)];   % desired part

end

