//
// Institute for Signal Processing (University of Luebeck, Germany)
// Copyright (c) 2011 by Radoslaw Mazur
//
// Permission to use, copy, modify, and distribute this software without
// fee is hereby granted FOR RESEARCH/EDUCATION PURPOSES only, provided
// that this copyright notice appears in all copies and in all supporting
// documentation, and that the software is not redistributed for any
// fee (except for a nominal shipping charge).
//
// For any other uses of this software, in original or modified form,
// including but not limited to consulting, production or distribution
// in whole or in part, specific prior permission must be obtained
// from the author.
// Signal processing methods and algorithms implemented by this
// software may be claimed by patents owned by others.
//
// The author makes no representation about the suitability of this
// software for any purpose. It is provided "as is" without warranty
// of any kind, either expressed or implied.
// Beware of the bugs.
//
//     Revision history
//
//     Ver     Date         Description
//     -------------------------------------------------------------------
//     0.5     14-10-2011   basic version



#include "mex.h"
#include <iostream>
#include <stdio.h>
#include <math.h>
#include <time.h>

using namespace std;

void  do_shortening(double *c, double *wd, double *wu, double *h, int Lc, int Lh, int Lg, int fft_len, int numIter, double mue, double pd, double pu, int speakers, int microphones, double *ret_re);


void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] ){

  double *x,*y;
  mwSize mrows,ncols;

  //printf("Mex reached\n");

  /* Check for proper number of arguments. */
  if(nrhs!=14) {
    mexErrMsgTxt("Wrong number of inputs.");
  } else if(nlhs>1) {
    mexErrMsgTxt("Too many output arguments.");
  }
    // input 1 - c: the RIR
    double *c = mxGetPr(prhs[0]);
    if (mxGetM(prhs[0]) != 1 && mxGetN(prhs[0])!= 1){
        mexErrMsgTxt("c is not a vector");
    }
    int c_len = mxGetM(prhs[0])*mxGetN(prhs[0]);

    // input 2 - wd: desired widnow
    double *wd = mxGetPr(prhs[1]);
    if (mxGetM(prhs[1]) != 1 && mxGetN(prhs[1])!= 1){
        mexErrMsgTxt("wd is not a vector");
    }
    int wd_len = mxGetM(prhs[1])*mxGetN(prhs[1]);

    // input 3 - wu: undesired widnow
    double *wu = mxGetPr(prhs[2]);
    if (mxGetM(prhs[2]) != 1 && mxGetN(prhs[2])!= 1){
        mexErrMsgTxt("wu is not a vector");
    }
    int wu_len = mxGetM(prhs[2])*mxGetN(prhs[2]);
    if (wd_len != wu_len){
        mexErrMsgTxt("wu and wd have different length");
    }

    // input 4 - h: initial eqalizer
    double *h = mxGetPr(prhs[3]);
    if (mxGetM(prhs[3]) != 1 && mxGetN(prhs[3])!= 1){
        mexErrMsgTxt("h is not a vector");
    }
    int h_len = mxGetM(prhs[3])*mxGetN(prhs[3]);


    int Lc          = *(mxGetPr(prhs[4]));
    int Lh          = *(mxGetPr(prhs[5]));
    int Lg          = *(mxGetPr(prhs[6]));
    int fft_len     = *(mxGetPr(prhs[7]));
    int iter        = *(mxGetPr(prhs[8]));
    double mue      = *(mxGetPr(prhs[9]));
    double pd       = *(mxGetPr(prhs[10]));
    double pu       = *(mxGetPr(prhs[11]));
    int speakers    = *(mxGetPr(prhs[12]));
    int microphones = *(mxGetPr(prhs[13]));


  /* Create matrix for the return argument. */
  plhs[0] = mxCreateDoubleMatrix(fft_len*microphones , 1, mxREAL);
  double *ret_re = mxGetPr(plhs[0]);
   //printf("Mex: call for helper\n");

  do_shortening(c, wd, wu, h, Lc, Lh, Lg, fft_len, iter, mue, pd, pu, speakers, microphones, ret_re);
}

