//
// Institute for Signal Processing (University of Luebeck, Germany)
// Copyright (c) 2011 by Radoslaw Mazur
//
// Permission to use, copy, modify, and distribute this software without
// fee is hereby granted FOR RESEARCH/EDUCATION PURPOSES only, provided
// that this copyright notice appears in all copies and in all supporting
// documentation, and that the software is not redistributed for any
// fee (except for a nominal shipping charge).
//
// For any other uses of this software, in original or modified form,
// including but not limited to consulting, production or distribution
// in whole or in part, specific prior permission must be obtained
// from the author.
// Signal processing methods and algorithms implemented by this
// software may be claimed by patents owned by others.
//
// The author makes no representation about the suitability of this
// software for any purpose. It is provided "as is" without warranty
// of any kind, either expressed or implied.
// Beware of the bugs.
//
//     Revision history
//
//     Ver     Date         Description
//     -------------------------------------------------------------------
//     0.5     14-10-2011   basic version

#ifndef SHORTENING_H
#define SHORTENING_H


typedef double2 Complex;

class shorteningData {
    public:
        double *c;
        double *wd;
        double *wu;
        double *h;
        double *ret;

        double *dev_c;
        double *dev_wd;
        double *dev_wu;
        double *dev_h;
        double *dev_ret;

        Complex *C;
        Complex *Ck;

        int c_len;
        int c_ges_len;
        int w_len;
        int w_ges_len;
        int h_len;
        int h_ges_len;
        int fft_len;
        int sf_len;
        int speakers;
        int microphones;

        Complex *conv_tmp_in;
        Complex *conv_tmp_out;

        double *gk;

        double *bu;
        double *bd;
        double *add_tmp1;
        double *add_tmp2;

        double *gradient_out;
        double *F1;

        double *add_partial;

        double *SAgu;
        double *SAgd;


        shorteningData();
        shorteningData(double *cc, double *wwd, double *wwu, double *hh, double *ret_re, int cl, int wl, int hl , int fl,int spk, int mic);

        virtual ~shorteningData();
        void copyToDevice();
        void copyToHost();

    protected:
    private:
};


#endif // IHORTENING_H


