//
// Institute for Signal Processing (University of Luebeck, Germany)
// Copyright (c) 2011 by Radoslaw Mazur
//
// Permission to use, copy, modify, and distribute this software without
// fee is hereby granted FOR RESEARCH/EDUCATION PURPOSES only, provided
// that this copyright notice appears in all copies and in all supporting
// documentation, and that the software is not redistributed for any
// fee (except for a nominal shipping charge).
//
// For any other uses of this software, in original or modified form,
// including but not limited to consulting, production or distribution
// in whole or in part, specific prior permission must be obtained
// from the author.
// Signal processing methods and algorithms implemented by this
// software may be claimed by patents owned by others.
//
// The author makes no representation about the suitability of this
// software for any purpose. It is provided "as is" without warranty
// of any kind, either expressed or implied.
// Beware of the bugs.
//
//     Revision history
//
//     Ver     Date         Description
//     -------------------------------------------------------------------
//     0.5     14-10-2011   basic version

#ifndef KERNELS_H
#define KERNELS_H

__global__ void clear_mem(int count, double *data);
__global__ void clear_mem(int count, Complex *data);

__global__ void complex_conj(int count, int total, Complex *in, Complex *out);

__global__ void calc_filter_coef_forward(Complex *C, Complex *in, Complex *out,
                                         int sf_len, int speakers, int microphones, double fft_fact);

__global__ void make_calcs(double *gk, double *wu, double *bu, double *add_out, double pu, int len);

__global__ void sum_reduce(double *in, double *out, int len, double *inv_SG);

__global__ void gradient_pre_calc(double *bu, double *bd, double *SAgu, double *SAgd, double *out, int count);


__global__ void calc_filter_coef_back(Complex *Ck, Complex *in, Complex *out,
                                      int sf_len, int speakers, int microphones, double fft_fact);

__global__ void apply_gradient(double *F1, double *h, double mue, int fft_len, int Lh, int speakers);
#endif // KERNELS_H


