#ifndef ICADATA_H
#define ICADATA_H

#include "../src/basic_data_types.cu"


class icaData {
    public:
        cu2dVect *in;
        cu2dVect *out;
        cu2dMatrix *w;

        int data_points;
        int f_bins;
        int data_ges;
        int iterations;
        float step_size;

        cu2dVect *dev_in;
        cu2dVect *dev_out;
        cu2dMatrix *dev_w;

        icaData();
        icaData(int d_points, int fb);
        icaData(int d_points, int fb, int it);
        virtual ~icaData();
        void copyToDevice();
        void copyToHost();

    protected:
    private:
};

class icaData_3d {
    public:
        cu3dVect *in;
        cu3dVect *out;
        cu3dMatrix *w;

        int data_points;
        cuFDType inv_mlen;
        int f_bins;
        int data_ges;
        int iterations;
        float step_size;

        cu3dVect *dev_in;
        cu3dVect *dev_out;
        cu3dMatrix *dev_w;

        icaData_3d();
        icaData_3d(int d_points, int fb);
        icaData_3d(int d_points, int fb, int it);
        virtual ~icaData_3d();
        void copyToDevice();
        void copyToHost();

    protected:
    private:
};


#endif // ICADATA_H


